public class Time {
	private int hours, minutes, seconds;
	private final static int SECDAY = 86400;
	
	public Time(int h, int min, int sec) {
		setTime(h, min, sec);
	}

	public Time(int secTotal) {
		setTime(secTotal);
	}

	public Time() {}
	
	public boolean setTime(int h, int min, int sec) {
		if ((h >= 0 && h <= 23) &&
			(min >= 0 && min <= 59) &&
			(sec >= 0 && sec <= 59)) {
			hours = h;
			minutes = min;
			seconds = sec;
			return true;
		} else
			return false;
	}

	public boolean setTime(int secTotal) {
		if (secTotal >= 0 && secTotal < SECDAY) {
			hours = secTotal/3600;
			minutes = (secTotal-hours*3600)/60;
			seconds =  secTotal-hours*3600-minutes*60;
			return true;
		} else
			return false;
	}

	public void setTime(Time t) {
		hours = t.hours;
		minutes = t.minutes;
		seconds = t.seconds;
	}
	
	public int getHours() {
		return hours;
	}

	public int getMinutes() {
		return minutes;
	}

	public int getSeconds() {
		return seconds;
	}

	public boolean setHours(int h) {
		if (h >= 0 && h <= 23) {
			hours = h;
			return true;
		} else
			return false;
	}

	public boolean setMinutes(int min) {
		if (min >= 0 && min <= 59) {
			minutes = min;
			return true;
		} else
			return false;
	}

	public boolean setSeconds(int sec) {
		if (sec >= 0 && sec <= 59) {
			seconds = sec;
			return true;
		} else
			return false;
	}
	
	public int toSeconds() {
		return hours * 3600 + minutes * 60 + seconds;
	}

	public void addDuration(Duration d) {
		setTime( (int) ((toSeconds() + d.toSeconds())%SECDAY) );
	}

	public Duration getDistanceTo(Time t) {
		Duration d = new Duration();
		if (toSeconds() <= t.toSeconds())
			d.setDuration(t.toSeconds() - toSeconds()); // selber Tag
		else {
			d.setDuration(SECDAY - toSeconds() + t.toSeconds()); // nächster Tag
		}
		return d;
	}

	public String toString() {
		return String.format("%02d:%02d:%02d Uhr", hours, minutes, seconds);
	}
}